#!/bin/bash
#SBATCH --mem=15G
#SBATCH --cpus-per-task=4
#SBATCH --time=16:00:00
#SBATCH --output=/scratch/shared/beegfs/yuki/fast/slurm/person/IN1k-new-%a.out
#SBATCH --partition=gpu
#SBATCH --gres=gpu:1
#SBACTH --open-mode=append
#SBATCH --job-name=persondet
#SBATCH --exclude=gnodec1,gnodee1
#SBATCH --array=0-26%13


echo $SLURM_ARRAY_TASK_ID
X=$((${SLURM_ARRAY_TASK_ID}*50000))
Y=$(((${SLURM_ARRAY_TASK_ID} + 1)*50000))

in_file=_tmp_in1k-noface_${SLURM_ARRAY_TASK_ID}.txt
rm ${in_file}
results_dir='/scratch/shared/beegfs/yuki/fast/in1k/person/'
mkdir -p ${results_dir}
< /users/yuki/adiwol/IN1k_train_noface.txt tail -n +"$X" | head -n "$((Y - X))" >> ${in_file}

echo "from " ${X}
echo "to " ${Y}

# ETA 4-6Hz
/scratch/shared/beegfs/yuki/envs/py37/bin/python3 -W ignore main_person_detector.py \
  --img_list=${in_file} \
  --save_folder=${results_dir}